//+------------------------------------------------------------------+
//|                                         Kase Peak oscillator.mq4 |
//|                                                 Copyright  2007 |
//|                                          http://www.whatever.com |
//|                                  addapted by mladen@whatever.com |
//+------------------------------------------------------------------+

#property copyright "Copyright  2007"
#property link      "http://www.whatever.com"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Gold
#property indicator_color2 Red
#property indicator_color3 Lime

//---- input parameters
extern int Periods=30;
//---- buffers
double LN[];
double RedHist[];
double GreenHist[];
double RWArr[];
double Pk[];
double SqrtPer;


//
//
//
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
//
//

int init()
  {
   IndicatorBuffers(5);
   IndicatorShortName("Kase Peak Oscillator ("+Periods+")");  
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,LN);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,RedHist);
   SetIndexStyle(2,DRAW_HISTOGRAM);//DRAW_NONE
   SetIndexBuffer(2,GreenHist);

   SetIndexBuffer(3,RWArr);
   SetIndexBuffer(4,Pk);

   SetIndexDrawBegin(0,Periods+3+3+8+Periods);
   SetIndexDrawBegin(1,Periods+3+3+8+Periods);
   SetIndexDrawBegin(2,Periods+3+3+8+Periods);

   SqrtPer = MathSqrt(Periods);
   
   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double rwh  = 0;
   double rwl  = 0;
   double mn   = 0;
   double sd   = 0;
   double val1 = 0;
   double val2 = 0;
   double atr  = 0;
   int i;   
   int    counted_bars=IndicatorCounted();
   
   
      //
      //
      //
      //
      //
      //
   
   
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   if(counted_bars>=Periods+3+3+8+Periods) counted_bars-=(Periods+3+3+8+Periods);
   
   //
   //
   //
   //
   //
   
      if(counted_bars==0)
         {
            for(i=(Bars-1); i>=(Bars-1)-counted_bars-Periods-3-3-8-Periods+1; i--)
               {
                  RWArr[i]     = 0;
                  Pk[i]        = 0;
                  LN[i]        = 0;
                  RedHist[i]   = 0;
                  GreenHist[i] = 0;         
               }          
         }

   //
   //
   //
   //
   //
   //
   
      for(i=(Bars-1)-counted_bars-Periods; i>=0; i--)
      {
         rwh = 0; rwl = 0;
         atr = iATR(NULL, 0, Periods,i)*SqrtPer;
         if(atr!=0){
            rwh = (High[i]-Low[i+Periods])/atr;
            rwl = (High[i+Periods]-Low[i])/atr;
         }
         RWArr[i] = rwh - rwl;
      }

   //
   //
   //
   //
   //
   //
   
      for(i=(Bars-1)-counted_bars-Periods-3; i>=0; i--)
      {
         Pk[i] = iMAOnArray(RWArr,Bars,3,0,MODE_LWMA,i);
      }
      
   //
   //
   //
   //
   //
   
   for(i=(Bars-1)-counted_bars-Periods-3-3-8-Periods; i>=0; i--)
   {
      mn = iMAOnArray(Pk,Bars,Periods,0,MODE_SMA,i);
      sd = iStdDevOnArray(Pk,Bars,Periods,0,MODE_SMA,i);
      
      //
      //
      //
      //
      
         if(mn+(1.33*sd)>2.08)
            val1 = mn+(1.33*sd);
         else  
            val1 = 2.08;
      //
      //
      //
      //
      
         if(mn-(1.33*sd)<-1.92)
            val2 = mn-(1.33*sd);
         else  
            val2 = -1.92;     
   
   //
   //
   //
   //
   
      if(Pk[i+1]>=0 && Pk[i]>0)
         LN[i] = val1;
      else
         if(Pk[i+1]<=0 && Pk[i]<0)
            LN[i] = val2;
         else
            LN[i] = 0;
   
   //
   //         
   //
   //
   
      if(Pk[i+1]>Pk[i])
         RedHist[i] = Pk[i];
      else
         RedHist[i] = 0;

      if(Pk[i]>Pk[i+1])
         GreenHist[i] = Pk[i];
      else
         GreenHist[i] = 0;
   } 
   
   return(0);
  }
//+------------------------------------------------------------------+